#include "configs.h" // configuration bits
#include "7seg_chars.h" 
#include <xc.h> 
#include <stdint.h>
#include <stdio.h>
#include <math.h>  

short PORTA_shdw = 0;  //shadow ports
short PORTD_shdw = 0;
uint8_t DISPLAY[5];			// Display memory, last byte is clock colons / degree sign
uint8_t CURRENT_SEG = 0;
char display_numeric_lookup[] = {_0, _1, _2, _3, _4, _5, _6, _7, _8, _9};
char display_alpha_lookup[] = {_SPACE,_A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V, _W, _X, _Y, _Z};

//encoder variables
char counter = 0; // encoder count
char counter2 = 0; // encoder count
double counterN = 2.2; //counter divider ratio
char dutyN = 2;
char position; // last encoder position
char pb;//pushbutton status
uint16_t buttimer=0;
uint8_t releasetimer=0;
#define Encoder_SW PORTGbits.RG5
#define Encoder_DT PORTBbits.RB6
#define Encoder_CLK PORTBbits.RB7

//7 seg display mapping
#define SEGMENT_A output_d(0b11111110);
#define SEGMENT_B output_d(0b11111101);
#define SEGMENT_C output_d(0b11111011);
#define SEGMENT_D output_d(0b11110111);
#define SEGMENT_E output_d(0b11101111);
#define SEGMENT_F output_d(0b11011111);
#define SEGMENT_G output_d(0b10111111);
#define SEGMENT_DP output_d(0b01111111);
#define SEGMENT_NONE output_d(0b11111111);

//timers
#define TMR2PRESCALER 16 // PWM timer prescaler
#define _XTAL_FREQ 32000000 // needed for delay functions

//relay toggle variables
#define Relay PORTAbits.RA0
int oldButtonState = 0;
int pb_toggle = 0;

//PWM
#define PWM1_CONFIG 0x120    //0x50 PR2 => 25 kHz

//Temp sensor
#define RTD_A 3.9083E-3
#define RTD_B -5.775E-7
#define MAX 100
char temparr[MAX];
uint8_t readRTD;
float Rt; 
float temp;
uint16_t RTDraw;

typedef enum {
//        EVT_LEFT,
//        EVT_RIGHT,
        EVT_BUTTON,
        EVT_LONG_PRESS,
        EVT_NONE
} EVENTS;

EVENTS event = EVT_NONE;

void output_d(short x){
    PORTD_shdw = x; 
    PORTD = PORTD_shdw; 
}

void output_a(short x){
    PORTA_shdw = x;
    PORTA = PORTA_shdw; 
}

void clear_a(){
    PORTA_shdw = 0x00; 
    PORTA = PORTA_shdw; 
}

PWM_Duty(unsigned int duty) {
  if(duty<1024) {
    CCPR3L = (uint8_t) (duty >> 2);
    CCP3CON |= (duty & 3) << 4;
  }
}

int PWM_Initialize() {
//  TMR2PRESCALAR == 1
//    T2CKPS0 = 0;
//    T2CKPS1 = 0;
//  TMR2PRESCALAR == 4
    T2CKPS0 = 1;
    T2CKPS1 = 0;
//  TMR2PRESCALAR == 16
//    T2CKPS0 = 1;
//    T2CKPS1 = 1;

  CCP3M3 = 1; //configure CCP3 for PWM
  CCP3M2 = 1;
  
  TMR2ON = 1; //turn timer 2 on
  
  PR2 = PWM1_CONFIG;       // pwm frequency adjust
}

void PWM_DeInit(){
    CCP3M3 = 0; //configure CCP3 for PWM
    CCP3M2 = 0;
}

void spi_init(){
    SSP1CON1 = (0<<5); //clear bit 5, disable serial port
    
    TRISC = (0<<3) | (1<<4) | (0<<5) | (0<<6)| (0<<6); //clear RC3, RC5, RC6 (output: SCK1, SDO, CS) and set RC4, RC7 (input: SDI, MAX RDY)
    SSP1CON1 = (1<<4) | (0<<3) | (0<<2) | (0<<1) | (0<<0); // 4: (CKP), 3-0:(SSPM = 0000; Master mode , Fosc/4)
    SSP1STAT = (0<<7) | (0<<6); //7 (SPI Master mode), 0 = Input data sampled at middle of data output time, 6: (CKE) transmit on clock transition to active
    SSP1ADD = 0; 
    
    SSP1CON1bits.SSPEN = 1; //set bit 5, enable serial port
    
}

uint8_t max31865_interface_spi_readwrite(uint8_t reg, uint8_t data)
{
    LATCbits.LATC6 = 0;       // CS low
    NOP();                    // Small delay
    SSP1BUF = reg;           // Send address
    while(!PIR1bits.SSP1IF);  // Wait
    PIR1bits.SSP1IF = 0;
    SSP1BUF = data;           // Send dummy byte / data
    while(!PIR1bits.SSP1IF);  // Wait
    PIR1bits.SSP1IF = 0;
    LATCbits.LATC6 = 1;       // CS high
    return SSP1BUF;           // Return received data
}

float calculateTemperature() {
  float Z1, Z2, Z3, Z4;
  //perform 1 shot measurement
  max31865_interface_spi_readwrite(0x80,0xA8); //set 1-shot bit to trigger conversion (D5)
  RTDraw = max31865_interface_spi_readwrite(0x01,0x00); //read RTD MSBs
  RTDraw <<=8;
  RTDraw |= max31865_interface_spi_readwrite(0x02,0x00); //read RTD LSBs
  RTDraw >>= 1;
  max31865_interface_spi_readwrite(0x80,0xA0); //clear 1-shot bit (D0)
  
  Rt = RTDraw;
  Rt /= 32768;
  Rt *= 400;

  // Serial.print("\nResistance: "); Serial.println(Rt, 8);

  Z1 = -RTD_A;
  Z2 = RTD_A * RTD_A - (4 * RTD_B);
  Z3 = (4 * RTD_B) / 100;
  Z4 = 2 * RTD_B;

  temp = Z2 + (Z3 * Rt);
  temp = (sqrt(temp) + Z1) / Z4;

  if (temp >= 0)
    return temp;

  // ugh.
  Rt /= 100;
  Rt *= 100; // normalize to 100 ohm

  float rpoly = Rt;

  temp = -242.02;
  temp += 2.2228 * rpoly;
  rpoly *= Rt; // square
  temp += 2.5859e-3 * rpoly;
  rpoly *= Rt; // ^3
  temp -= 4.8260e-6 * rpoly;
  rpoly *= Rt; // ^4
  temp -= 2.8183e-8 * rpoly;
  rpoly *= Rt; // ^5
  temp += 1.5243e-10 * rpoly;

}

 void init() {
     
//Oscillator setup
OSCCONbits.IRCF = 0x0F; //set internal osc to 16mhz
OSCCONbits.SCS = 0x00; //system clock setup

// Port A Config
TRISA = 0x00; //set Port A as digital output
PORTA = 0X00;  //all off
// Port B Config
TRISB = (1<<6) | (1<<7); //set RB6, and RB7 as input and others as output
WPUB = (1<<6) | (1<<7); //enable weak pull up on RB6 and RB7
//ANSELB = (0<<6) | (0<<7); //configure all of port B to be digital 
//ODCONB = (1<<6) | (1<<7) ; //configure RB6 and RB7 to be open drain drive (sink only)
// Port D Config
TRISD=0x00;  //set Port D as digital output
PORTD=0X00;  //all off
// Port G Config
OPTION_REG= 0x7F;
TRISG = (1<<5);	//set RG5 as input and others as output
WPUG = (1<<5); //enable weak pull up on RG5


//Alternate pin functions 
//APFCON1 = (1<<0) | (1<<6); //set bit 0 (RB3) and bit 6 (RB0) as CCP2 and CCP1 in alternate pin register 1
        
//Interrupt setup
TMR0IE = 1;            // enable interrupt on TMR0 overflow
GIE = 1;               // global interrupt enable
TMR0CS = 0;            // internal clock selector 

//Encoder setup
position = Encoder_CLK;
 }
 
// static uint16_t UpdateMovingAverage(uint8_t newValue)
//{
//    #define ticksArraySize 4
//    static uint16_t ticksSum = 0;
//    static uint8_t ticksArray[ticksArraySize] = { 0 };
//    static uint8_t ticksArrayIdx = 0;
//    uint8_t prev = ticksArray[ticksArrayIdx];
//    ticksArray[ticksArrayIdx] = newValue;
//    ticksSum = ticksSum + newValue - prev;
//    ticksArrayIdx++;
//    if (ticksArrayIdx == ticksArraySize)
//    {
//        ticksArrayIdx = 0;
//    }
//    return 30 * ticksSum / ticksArraySize;
//}
 
 void displaybuff(int i){
     
    unsigned int a,b,c,d,e,f,g,h; //display storage variables
    
    a=i%10;//4th digit is saved here
    b=i/10;
    c=b%10;//3rd digit is saved here
    d=b/10;
    e=d%10; //2nd digit is saved here
    f=d/10;
    g=f%10; //1st digit is saved here
    
    if (i < 10){
        DISPLAY[3] = display_numeric_lookup[a]; //lookup bitmap in 7_seg_chars header file according to display_lookup array
        DISPLAY[2] = display_alpha_lookup[0];
        DISPLAY[1] = display_alpha_lookup[0];
        DISPLAY[0] = display_alpha_lookup[0];
    }
    else if (i < 100){
        DISPLAY[3] = display_numeric_lookup[a]; 
        DISPLAY[2] = display_numeric_lookup[c];
        DISPLAY[1] = display_alpha_lookup[0];
        DISPLAY[0] = display_alpha_lookup[0];
    }
    else if (i < 1000){
        DISPLAY[3] = display_numeric_lookup[a]; 
        DISPLAY[2] = display_numeric_lookup[c];
        DISPLAY[1] = display_numeric_lookup[e];
        DISPLAY[0] = display_alpha_lookup[0];
    }
    else {
        DISPLAY[3] = display_numeric_lookup[a]; 
        DISPLAY[2] = display_numeric_lookup[c];
        DISPLAY[1] = display_numeric_lookup[e];
        DISPLAY[0] = display_numeric_lookup[g];
    }
}
 
 void printDigit(int N)
{
    int i = 0; 
    int r;
    while (N != 0) { // till N becomes 0
        r = N % 10; // extract the last digit of N
        temparr[i] = r; // put the digit in arr[]
        i++;
        N = N / 10; // update N to N/10 to extract next last digit
    }
}
 
 void ledinit(){ 
    for (counter = 0; counter < 100; counter++) {
        counter2 =  (int)(counter / 1.5);  //divide by x, counter: 0-100, duty: 0-x%
        PWM_Duty(counter2*dutyN); //change duty cycle accordingly
     __delay_us(50);
    }
    for (counter = 100; counter > 35; counter--) {
        counter2 =  (int)(counter / counterN);  //divide by x, counter: 0-100, duty: 0-x%
        PWM_Duty(counter2*dutyN); //change duty cycle accordingly
     __delay_us(25);
    }
}
 
void main()
{
init();
spi_init();
int tempint;
int count;

max31865_interface_spi_readwrite(0x80,0xA0); //config register write addr: 0x80. set config register bits 1000000 = 0x80
while(1)  {
    
    int newButtonState = pb;
    if (newButtonState == 1 && oldButtonState == 0) {

        if (pb_toggle == 0) {
            pb_toggle = 1;
            
            DISPLAY[3] = display_alpha_lookup[14]; //N
            DISPLAY[2] = display_alpha_lookup[15]; //O
            DISPLAY[1] = display_alpha_lookup[0]; //space
            DISPLAY[0] = display_alpha_lookup[0]; //space
            counter = 0;
            counter2 =0; 
            PWM_Duty(0);
            PWM_Initialize();
            TRISAbits.TRISA0 = 1; // toggle relay on
            ledinit();
        } 
        else {
            // Toggle off
            pb_toggle = 0;
            TRISAbits.TRISA0 = 0; // toggle relay off    
            PWM_Duty(0);
            PWM_DeInit();
        }
  }
    if (counter > 24){
        counter2 = (int)(counter / counterN);  //divide by 2, counter: 0-100, duty: 0-50%
        PWM_Duty(counter2*dutyN); //change duty cycle accordingly
    }
    if (counter < 10){
        counter2 = (int)(counter / counterN);  //divide by 2, counter: 0-100, duty: 0-50%
        PWM_Duty(counter2*dutyN); //change duty cycle accordingly
    }
  
  oldButtonState = newButtonState;

        if (TRISA0 == 0) {
            DISPLAY[3] = display_alpha_lookup[6]; //F
            DISPLAY[2] = display_alpha_lookup[6]; //F
            DISPLAY[1] = display_alpha_lookup[15]; //O
            DISPLAY[0] = display_alpha_lookup[0]; //space
        }
        if (TRISA0 ==  1){
            calculateTemperature();
            tempint = (int)temp; 
            printDigit(tempint);
            count = (tempint == 0) ? 1  : (log10(tempint) + 1); //calculate total digits in temp
            
            if (count == 2 && Encoder_CLK == position) {
                DISPLAY[3] = display_alpha_lookup[3]; //C
                DISPLAY[2] = display_numeric_lookup[temparr[0]]; //temp digit 2
                DISPLAY[1] = display_numeric_lookup[temparr[1]]; //temp digit 1
                DISPLAY[0] = display_alpha_lookup[0]; //space
            }
            if (count == 3 && Encoder_CLK == position) {
                DISPLAY[3] = display_alpha_lookup[3]; //C
                DISPLAY[2] = display_numeric_lookup[temparr[0]]; //temp digit 3
                DISPLAY[1] = display_numeric_lookup[temparr[1]]; //temp digit 2
                DISPLAY[0] = display_numeric_lookup[temparr[2]]; //temp digit 1
            }
//            else if (Encoder_DT != position){
//                displaybuff(counter);
//            }
        }
    }
}


void __interrupt() display_encoder  (void) {
    
if(INTCONbits.T0IF && INTCONbits.T0IE) {// if timer flag is set & interrupt enabled
                                    
    TMR0 -= 250;              // reload the timer - 250 uS per interrupt

    switch(CURRENT_SEG) {
		case 0:	SEGMENT_A
				output_a(((DISPLAY[3]&0x01)<<3)|((DISPLAY[2]&0x01)<<4)|((DISPLAY[1]&0x01)<<7)|((DISPLAY[0]&0x01)<<6));
				break;
		case 1:	SEGMENT_B
				output_a(((DISPLAY[3]&0x02)<<2)|((DISPLAY[2]&0x02)<<3)|((DISPLAY[1]&0x02)<<6)|((DISPLAY[0]&0x02)<<5));
				break;
		case 2:	SEGMENT_C
				output_a(((DISPLAY[3]&0x04)<<1)|((DISPLAY[2]&0x04)<<2)|((DISPLAY[1]&0x04)<<5)|((DISPLAY[0]&0x04)<<4));
				break;
		case 3:	SEGMENT_D
				output_a(((DISPLAY[3]&0x08))|((DISPLAY[2]&0x08)<<1)|((DISPLAY[1]&0x08)<<4)|((DISPLAY[0]&0x08)<<3));
				break;
		case 4:	SEGMENT_E
				output_a(((DISPLAY[3]&0x10)>>1)|((DISPLAY[2]&0x10))|((DISPLAY[1]&0x10)<<3)|((DISPLAY[0]&0x10)<<2));
				break;
		case 5:	SEGMENT_F
				output_a(((DISPLAY[3]&0x20)>>2)|((DISPLAY[2]&0x20)>>1)|((DISPLAY[1]&0x20)<<2)|((DISPLAY[0]&0x20)<<1));
				break;
		case 6:	SEGMENT_G
				output_a(((DISPLAY[3]&0x40)>>3)|((DISPLAY[2]&0x40)>>2)|((DISPLAY[1]&0x40)<<1)|((DISPLAY[0]&0x40)));
				break;
//		case 7:	SEGMENT_DP
//				output_a((((DISPLAY[3]&0x80) _ADD_HEATER_STATUS)>>1)|(((DISPLAY[2]&0x80) _ADD_HEATER_2_STATUS)>>2)|((DISPLAY[1]&0x80)>>3)|((DISPLAY[0]&0x80)>>4));
//				break;
		default:SEGMENT_NONE			
	}
    CURRENT_SEG++;
   __delay_us(250); //increase brightness
   
    if (CURRENT_SEG > 7) {
        CURRENT_SEG=0;
    }
    clear_a(); //clear anodes to prevent ghosting
    
    //	 ENCODER READOUT

    if (Encoder_CLK != position){
        if (Encoder_DT != position && TRISA0 == 1){
            if (counter > 0){
            counter -- ; // decrease the counter
            displaybuff(counter);
            __delay_ms(10); 
            }
         }
        else{
            if (counter < 100 && TRISA0 == 1){
            counter ++ ; // increase the counter 
            displaybuff(counter);
            __delay_ms(10); 
            }
        }           
    }
    position = Encoder_CLK;     

	// Encoder button readout
	if (!Encoder_SW||(buttimer>0&&buttimer<72))	{ // 60 ms debounce on press
		buttimer++;
    }
	else {
		buttimer=0;
    }
	
	if (Encoder_SW&&(releasetimer>0)) {		// 30 ms debounce on release
		releasetimer--;
    }
	else if (!Encoder_SW&&buttimer>1) {
		releasetimer=36;
	}
	if (buttimer>512) {
        pb = 1;
    }
    else {
        pb = 0;
    }
 
  }

T0IF = 0; //reset timer 0 interrupt flag
}